/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.highlighter.HighlighterConfig;
import com.anthonyhilyard.iceberg.events.NewItemPickupEvent;
import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Highlighter {
    public static final ResourceLocation NEW_ITEM_MARKS = new ResourceLocation("highlighter", "textures/gui/newitemmarks.png");
    private static Set<Integer> markedSlots = new HashSet<Integer>(36);

    @SubscribeEvent
    public static void preItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack item = event.getItem().func_92059_d();
        Highlighter.handlePreItemPickup(player, item);
    }

    @SubscribeEvent
    public static void newItemPickup(NewItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack item = event.getItemStack();
        Highlighter.handlePreItemPickup(player, item);
    }

    private static void handlePreItemPickup(PlayerEntity player, ItemStack item) {
        int slot = player.field_71071_by.func_70432_d(item);
        if (slot == -1) {
            slot = player.field_71071_by.func_70447_i();
        }
        if (slot != -1) {
            markedSlots.add(slot);
        }
    }

    public static void itemClicked(int slotIndex) {
        markedSlots.remove(slotIndex);
    }

    public static void inventoryClosed() {
        if (((Boolean)HighlighterConfig.INSTANCE.clearOnInventoryClose.get()).booleanValue()) {
            markedSlots.clear();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (((Boolean)HighlighterConfig.INSTANCE.clearOnHover.get()).booleanValue()) {
            ContainerScreen invScreen;
            Slot slot;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r != null && mc.field_71462_r instanceof ContainerScreen && (slot = (invScreen = (ContainerScreen)mc.field_71462_r).getSlotUnderMouse()) != null && slot.func_75211_c() == event.getItemStack()) {
                markedSlots.remove(slot.getSlotIndex());
            }
        }
    }

    public static void renderNewItemMark(MatrixStack matrixStack, Slot slot) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184812_l_()) {
            if (markedSlots.contains(slot.getSlotIndex()) && slot.func_75216_d()) {
                Highlighter.render(matrixStack, slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f);
            } else {
                markedSlots.remove(slot.getSlotIndex());
            }
        }
    }

    private static void render(MatrixStack matrixStack, ItemStack item, int x, int y) {
        if (item.func_190926_b()) {
            return;
        }
        float timeOffset = Math.abs((float)(Util.func_211177_b() % 2000L) / 1000.0f - 1.0f);
        Color color = Color.func_240744_a_((TextFormatting)TextFormatting.WHITE);
        if (((Boolean)HighlighterConfig.INSTANCE.useItemNameColor.get()).booleanValue()) {
            color = ItemColor.getColorForItem((ItemStack)item, (Color)color);
        }
        RenderSystem.disableDepthTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)(-Easing.Ease((float)0.0f, (float)1.0f, (float)timeOffset)), 390.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NEW_ITEM_MARKS);
        RenderSystem.color3f((float)((float)(color.func_240742_a_() >> 16 & 0xFF) / 255.0f), (float)((float)(color.func_240742_a_() >> 8 & 0xFF) / 255.0f), (float)((float)(color.func_240742_a_() & 0xFF) / 255.0f));
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)((Boolean)HighlighterConfig.INSTANCE.useItemNameColor.get() != false ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
        matrixStack.func_227865_b_();
    }
}

